/******************** (C) COPYRIGHT 2003 STMicroelectronics ********************
* File Name          : submain.c
* Author             : MCD Application Team
* Date First Issued  : 18/07/2003
* Description        : This file is used for the STR71x Real Time 
*                      Clock Application Example application note (AN 1780).
********************************************************************************
* History:
*  04/10/2003 : V1.0
*  30/11/2004 : V2.0
*******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

#include "71x_lib.h"

extern void $Super$$main(void);
#ifdef USE_SERIAL_PORT
   void init_serial(void);
#endif

#ifdef USE_LCD
  extern void LCD_Init(void);
#endif
void $Sub$$main(void)
{
  int temp;
  #ifdef DEBUG
    debug();
  #endif
#ifdef USE_SERIAL_PORT
  init_serial();                 /*  initialize the AP serial port A */
#endif

#ifdef USE_LCD
  LCDInit();
#endif

	__asm                      /*  enable IRQs */
	{
		MRS temp, CPSR
		BIC temp, temp, #0x80
		MSR CPSR_c, temp
	}
  $Super$$main();                  /*  calls the original function main() */
}
void init_serial(void)
{
  /*  Configure the GPIO pins */
  GPIO_Config(GPIO0, UARTX_Tx_Pin, GPIO_AF_PP);
  GPIO_Config(GPIO0, UARTX_Rx_Pin, GPIO_IN_TRI_CMOS);

  /*  Configure the UART 0 */
  UART_OnOffConfig(UARTX, ENABLE);       /*  Turn UART0 on */
  UART_FifoConfig (UARTX, ENABLE);       /*  ENABLE FIFOs */
  UART_FifoReset  (UARTX , UART_RxFIFO); /*  Reset the UART_RxFIFO */
  UART_FifoReset  (UARTX , UART_TxFIFO); /*  Reset the UART_TxFIFO */
  UART_LoopBackConfig(UART0 , DISABLE);  /*  Disable Loop Back */
                                         /* Configure the UART0 as following:
                                            - Baudrate = 9600 Bps
                                            - No parity
                                            - 8 data bits
                                            - 1 stop bit */
  UART_Config(UARTX,38400,UART_NO_PARITY,UART_1_StopBits,UARTM_8D);
  UART_RxConfig(UARTX ,ENABLE);          /*  ENABLE Rx */
}

